﻿
#Область ОбработчикиМетодовHTTP

Функция EventsCallPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/events/call";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии Манго отключено в настройках'"));
	КонецЕсли;
	
	ТелоЗапроса = РаскодироватьСтроку(Запрос.ПолучитьТелоКакСтроку(), СпособКодированияСтроки.КодировкаURL);
	ПараметрыТела = СтроковыеФункцииКлиентСервер.ПолучитьПараметрыИзСтроки(ТелоЗапроса, "&");
	
	ТелефонияПереопределяемый.ЗаписатьЗапросВЖурналРегистрации(ИмяСобытияДляЖурналаРегистрации, ПараметрыТела.json);
	
	УстановитьПривилегированныйРежим(Истина);
	
	Если Не ПроверитьSign(ПараметрыТела) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Неверно указана подпись запроса sign=%1'"), ПараметрыТела.sign));
	КонецЕсли;
	
	ЧтениеJSON = Новый ЧтениеJSON;
	ЧтениеJSON.УстановитьСтроку(ПараметрыТела.json);
	МассивИмен = Новый Массив;
	МассивИмен.Добавить("timestamp");
	ПараметрыЗапросаJSON = ПрочитатьJSON(ЧтениеJSON,,,,"ВосстановлениеJSON",ТелефонияСервер,,МассивИмен);
	ЧтениеJSON.Закрыть();
	
	ОбязательныеПараметры = Новый Массив;
	ОбязательныеПараметры.Добавить("entry_id");
	ОбязательныеПараметры.Добавить("call_id");
	ОбязательныеПараметры.Добавить("timestamp");
	ОбязательныеПараметры.Добавить("seq");
	ОбязательныеПараметры.Добавить("call_state");
	ОбязательныеПараметры.Добавить("location");
	ОбязательныеПараметры.Добавить("to");
	ОбязательныеПараметры.Добавить("from");
	
	Для Каждого ОбязательныйПараметр Из ОбязательныеПараметры Цикл
		Если Не ПараметрыЗапросаJSON.Свойство(ОбязательныйПараметр) Тогда
			Возврат СообщениеОбОшибке(
				400,
				ИмяСобытияДляЖурналаРегистрации,
				СтрШаблон(НСтр("ru='Отсутствует обязательный параметр %1.'"), ОбязательныйПараметр));
		КонецЕсли;
	КонецЦикла;
	
	Попытка
		Если НРег(ПараметрыЗапросаJSON.location) = "abonent" Тогда
		
			Если ПараметрыЗапросаJSON.call_state = "Appeared" Тогда
				
				Если ПараметрыЗапросаJSON.from.Свойство("extension") И ПараметрыЗапросаJSON.to.Свойство("number") Тогда
					
					ТелефонияСервер.ОбработатьИсходящийЗвонок(
						ПараметрыЗапросаJSON.timestamp,
						ПараметрыЗапросаJSON.from.extension,,
						ПараметрыЗапросаJSON.to.number,
						ПараметрыЗапросаJSON.entry_id,
						ПараметрыЗапросаJSON.timestamp
					);
					
				ИначеЕсли ПараметрыЗапросаJSON.from.Свойство("number") И ПараметрыЗапросаJSON.to.Свойство("extension")
					И НЕ ПараметрыЗапросаJSON.Свойство("command_id") Тогда
					
					УстановитьПривилегированныйРежим(Истина);
					
					МенеджерЗаписи = РегистрыСведений.ДанныеЗвонков.СоздатьМенеджерЗаписи();
					МенеджерЗаписи.ИдентификаторЗвонкаВАТС = ПараметрыЗапросаJSON.entry_id;
					МенеджерЗаписи.Прочитать();
					
					РегистрироватьЗвонок = Ложь;
					
					Если НЕ МенеджерЗаписи.Выбран() Тогда
						МенеджерЗаписи.ИдентификаторЗвонкаВАТС = ПараметрыЗапросаJSON.entry_id;
						МенеджерЗаписи.Записать();
						
						РегистрироватьЗвонок = Истина;
						
					КонецЕсли;
					
					УстановитьПривилегированныйРежим(Ложь);
					
					ТелефонияСервер.ОбработатьВходящийЗвонок(
						ПараметрыЗапросаJSON.from.number,
						ПараметрыЗапросаJSON.to.extension,
						ПараметрыЗапросаJSON.timestamp,
						ПараметрыЗапросаJSON.entry_id,
						РегистрироватьЗвонок,
						Истина,
						ПараметрыЗапросаJSON.to.number
					);
					
				КонецЕсли;
				
			ИначеЕсли ПараметрыЗапросаJSON.call_state = "Connected" Тогда
				
				Если ПараметрыЗапросаJSON.to.Свойство("extension") Тогда
					Пользователь = ПараметрыЗапросаJSON.to.extension;
				ИначеЕсли ПараметрыЗапросаJSON.from.Свойство("extension") Тогда
					Пользователь = ПараметрыЗапросаJSON.from.extension;
				КонецЕсли;
				
				ТелефонияСервер.ОбработатьИзменениеЗвонка(
					ПараметрыЗапросаJSON.entry_id,
					ПараметрыЗапросаJSON.timestamp,
					Пользователь
				);
				
			ИначеЕсли ПараметрыЗапросаJSON.call_state = "Disconnected" Тогда
				
				Пользователь = Неопределено;
				Если ПараметрыЗапросаJSON.to.Свойство("extension") Тогда
					Пользователь = ПараметрыЗапросаJSON.to.extension;
				ИначеЕсли ПараметрыЗапросаJSON.from.Свойство("extension") Тогда
					Пользователь = ПараметрыЗапросаJSON.from.extension;
				КонецЕсли;
				
				ТелефонияСервер.ОбработатьЗавершениеЗвонка(
					,,,
					ПараметрыЗапросаJSON.timestamp,,
					,,,
					ПараметрыЗапросаJSON.entry_id,,
					Пользователь
				);
				
			КонецЕсли;
			
		КонецЕсли;
		
	Исключение
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));
	КонецПопытки;
	
	Ответ = Новый HTTPСервисОтвет(200);
	Возврат Ответ;
	
КонецФункции

Функция EventsRecordingPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/events/recording";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии Манго отключено в настройках'"));
	КонецЕсли;
	
	ТелоЗапроса = РаскодироватьСтроку(Запрос.ПолучитьТелоКакСтроку(), СпособКодированияСтроки.КодировкаURL);
	ПараметрыТела = СтроковыеФункцииКлиентСервер.ПолучитьПараметрыИзСтроки(ТелоЗапроса, "&");
	
	ТелефонияПереопределяемый.ЗаписатьЗапросВЖурналРегистрации(ИмяСобытияДляЖурналаРегистрации, ПараметрыТела.json);
	
	УстановитьПривилегированныйРежим(Истина);
	
	Если Не ПроверитьSign(ПараметрыТела) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Неверно указана подпись запроса sign=%1'"), ПараметрыТела.sign));
	КонецЕсли;
	
	ЧтениеJSON = Новый ЧтениеJSON;
	ЧтениеJSON.УстановитьСтроку(ПараметрыТела.json);
	МассивИмен = Новый Массив;
	МассивИмен.Добавить("timestamp");
	ПараметрыЗапросаJSON = ПрочитатьJSON(ЧтениеJSON,,,,"ВосстановлениеJSON",ТелефонияСервер,,МассивИмен);
	ЧтениеJSON.Закрыть();
	
	ОбязательныеПараметры = Новый Массив;
	ОбязательныеПараметры.Добавить("recording_id");
	ОбязательныеПараметры.Добавить("recording_state");
	ОбязательныеПараметры.Добавить("seq");
	ОбязательныеПараметры.Добавить("entry_id");
	ОбязательныеПараметры.Добавить("call_id");
	ОбязательныеПараметры.Добавить("timestamp");
	
	Для Каждого ОбязательныйПараметр Из ОбязательныеПараметры Цикл
		Если Не ПараметрыЗапросаJSON.Свойство(ОбязательныйПараметр) Тогда
			Возврат СообщениеОбОшибке(
				400,
				ИмяСобытияДляЖурналаРегистрации,
				СтрШаблон(НСтр("ru='Отсутствует обязательный параметр %1.'"), ОбязательныйПараметр));
		КонецЕсли;
	КонецЦикла;
	
	НеобходимоОбработатьУведомление =
		ВРег(ПараметрыЗапросаJSON.recording_state) = ВРег("Completed")
		И ПараметрыЗапросаJSON.completion_code = 1000; // 1000 - Действие успешно выполнено
	
	Если НЕ НеобходимоОбработатьУведомление Тогда
		Ответ = Новый HTTPСервисОтвет(200);
		Возврат Ответ;
	КонецЕсли;
	
	Попытка
		ТелефонияСервер.ОбработатьЗавершениеЗвонка(,,,,,, ПараметрыЗапросаJSON.recording_id,, ПараметрыЗапросаJSON.entry_id);
	Исключение
		Возврат СообщениеОбОшибке(500,
			ИмяСобытияДляЖурналаРегистрации,
			ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));
	КонецПопытки;
	
	Ответ = Новый HTTPСервисОтвет(200);
	Возврат Ответ;
	
КонецФункции

Функция ResultCallbackPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/result/callback";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии отключено в настройках'"));
	КонецЕсли;
	
	Ответ = Новый HTTPСервисОтвет(501); // Not implemented
	Возврат Ответ;
	
КонецФункции

Функция ResultRoutePOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/result/route";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии отключено в настройках'"));
	КонецЕсли;
	
	Ответ = Новый HTTPСервисОтвет(501); // Not implemented
	Возврат Ответ;
	
КонецФункции

Функция ResultStatsPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/result/stats";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии отключено в настройках'"));
	КонецЕсли;
	
	Ответ = Новый HTTPСервисОтвет(501); // Not implemented
	Возврат Ответ;
	
КонецФункции

Функция pingGET(Запрос)
	
	Ответ = Новый HTTPСервисОтвет(200);
	Ответ.УстановитьТелоИзСтроки("ok");
	Возврат Ответ;
	
КонецФункции

#КонецОбласти

#Область СлужебныеПроцедурыИФункции

Функция СообщениеОбОшибке(КодСостояния, ВложенноеИмяСобытия, Комментарий)
	
	ЗаписьЖурналаРегистрации(
		ТелефонияПереопределяемый.СобытиеЖурналаРегистрации() + "." + ВложенноеИмяСобытия,
		УровеньЖурналаРегистрации.Ошибка,,,
		Комментарий);
	
	Ответ = Новый HTTPСервисОтвет(КодСостояния);
	Возврат Ответ;
	
КонецФункции

Функция ПроверитьSign(ПараметрыТела)
	
	НастройкиТелефонии = ТелефонияСервер.ПолучитьНастройкиТелефонии();
	РассчитанныйSign = ТелефонияСервер.ПолучитьSign(
		НастройкиТелефонии.vpbx_api_key,
		ПараметрыТела.json,
		НастройкиТелефонии.vpbx_api_salt
	);
	
	Возврат РассчитанныйSign = ПараметрыТела.sign;
	
КонецФункции

#КонецОбласти
