﻿
#Область ОбработчикиМетодовHTTP

Функция pingGET(Запрос)
	
	Ответ = Новый HTTPСервисОтвет(200);
	Ответ.УстановитьТелоИзСтроки("ok");
	Возврат Ответ;
	
КонецФункции

Функция itoolabsPingGET(Запрос)
	
	Ответ = Новый HTTPСервисОтвет(200);
	Ответ.УстановитьТелоИзСтроки("ok");
	Возврат Ответ;
	
КонецФункции

Функция mangoPingGET(Запрос)
	
	Ответ = Новый HTTPСервисОтвет(200);
	Ответ.УстановитьТелоИзСтроки("ok");
	Возврат Ответ;
	
КонецФункции

Функция yandexPingGET(Запрос)
	
	Ответ = Новый HTTPСервисОтвет(200);
	Ответ.УстановитьТелоИзСтроки("ok");
	Возврат Ответ;
	
КонецФункции

Функция itoolabsEventPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/event";
	
	ТелоЗапроса = РаскодироватьСтроку(Запрос.ПолучитьТелоКакСтроку(), СпособКодированияСтроки.КодировкаURL);
	ТелефонияПереопределяемый.ЗаписатьЗапросВЖурналРегистрации(ИмяСобытияДляЖурналаРегистрации, ТелоЗапроса);
	
	ПараметрыТела = ПолучитьПараметрыИзСтроки(ТелоЗапроса, "&");
	
	Если НЕ КорректныйКлюч(ПараметрыТела.crm_token, Перечисления.ДоступныеАТС.ДомRu) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Некорректный ключ'"));
	КонецЕсли;
	
	ОбязательныеПараметры = "cmd";
	Если НЕ ЕстьОбязательныеПараметры(ПараметрыТела,ОбязательныеПараметры) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры));
	КонецЕсли;
	
	ТипОперации = ПараметрыТела.cmd;
	Ответ = Неопределено;
	
	Попытка
		
		Если ТипОперации = "contact" Тогда
			
			ОбязательныеПараметры = "phone";
			Если НЕ ЕстьОбязательныеПараметры(ПараметрыТела, ОбязательныеПараметры) Тогда
				Возврат СообщениеОбОшибке(
					400,
					ИмяСобытияДляЖурналаРегистрации,
					СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры));
			КонецЕсли;
			
			ДанныеАбонента = ТелефонияСервер.ПолучитьДанныеКлиента(ПараметрыТела.phone);
			
			ЗаписьJSON = Неопределено;
			Если ДанныеАбонента <> Неопределено Тогда
				
				ЗаписьJSON = Новый ЗаписьJSON;
				ЗаписьJSON.УстановитьСтроку(Новый ПараметрыЗаписиJSON(ПереносСтрокJSON.Нет));
				ЗаписьJSON.ЗаписатьНачалоОбъекта();
				
				ЗаписьJSON.ЗаписатьИмяСвойства("contact_name");
				ЗаписьJSON.ЗаписатьЗначение(ДанныеАбонента.Представление);
				
				Если ДанныеАбонента.Свойство("ВнутреннийНомерОтветственного") Тогда
					ЗаписьJSON.ЗаписатьИмяСвойства("responsible");
					ЗаписьJSON.ЗаписатьЗначение(ДанныеАбонента.ВнутреннийНомерОтветственного);
				КонецЕсли;
				
				ЗаписьJSON.ЗаписатьКонецОбъекта();
				ПараметрыОтвета = ЗаписьJSON.Закрыть();
				
			КонецЕсли;
			
			Ответ = Новый HTTPСервисОтвет(200);
			Если ЗаписьJSON <> Неопределено Тогда
				Ответ.УстановитьТелоИзСтроки(ПараметрыОтвета);
			КонецЕсли;
			
		ИначеЕсли ТипОперации = "history" Тогда
			
			ОбязательныеПараметры = "callid";
			Если НЕ ЕстьОбязательныеПараметры(ПараметрыТела, ОбязательныеПараметры) Тогда
				Возврат СообщениеОбОшибке(
					400,
					ИмяСобытияДляЖурналаРегистрации,
					СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры));
			КонецЕсли;
			
			ТелефонияСервер.ОбработатьЗавершениеЗвонка(
				,,,,
				Число(ПараметрыТела.duration),,
				?(ПараметрыТела.Свойство("link"), ПараметрыТела.link, ""),,
				ПараметрыТела.callid,
				Ложь
			);
			
		ИначеЕсли ТипОперации = "event" Тогда
			
			ОбязательныеПараметры = "type,callid,phone,ext";
			Если НЕ ЕстьОбязательныеПараметры(ПараметрыТела, ОбязательныеПараметры) Тогда
				Возврат СообщениеОбОшибке(
					400,
					ИмяСобытияДляЖурналаРегистрации,
					СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры));
			КонецЕсли;
			
			Если НРег(ПараметрыТела.type) = "incoming" Тогда
				
				УстановитьПривилегированныйРежим(Истина);
				
				МенеджерЗаписи = РегистрыСведений.ДанныеЗвонков.СоздатьМенеджерЗаписи();
				МенеджерЗаписи.ИдентификаторЗвонкаВАТС = ПараметрыТела.callid;
				МенеджерЗаписи.Прочитать();
				
				РегистрироватьЗвонок = Ложь;
				
				Если НЕ МенеджерЗаписи.Выбран() Тогда
					МенеджерЗаписи.ИдентификаторЗвонкаВАТС = ПараметрыТела.callid;
					МенеджерЗаписи.Записать();
					
					РегистрироватьЗвонок = Истина;
					
				КонецЕсли;
				
				УстановитьПривилегированныйРежим(Ложь);
				
				НомерОрганизации = Неопределено;
				ПараметрыТела.Свойство("diversion", НомерОрганизации);
				
				ТелефонияСервер.ОбработатьВходящийЗвонок(
					ПараметрыТела.phone,
					ПараметрыТела.ext,
					ТекущаяДатаСеанса(),
					ПараметрыТела.callid,
					РегистрироватьЗвонок,
					Истина,
					НомерОрганизации
				);
			ИначеЕсли НРег(ПараметрыТела.type) = "outgoing" Тогда
				ТелефонияСервер.ОбработатьИсходящийЗвонок(
					ТекущаяДатаСеанса(),
					ПараметрыТела.ext,,
					ПараметрыТела.phone,
					ПараметрыТела.callid,
					ТекущаяДатаСеанса()
				);
			ИначеЕсли НРег(ПараметрыТела.type) = "accepted" Тогда
				ТелефонияСервер.ОбработатьИзменениеЗвонка(
					ПараметрыТела.callid,
					ТекущаяДатаСеанса(),
					ПараметрыТела.ext
				);
			ИначеЕсли НРег(ПараметрыТела.type) = "completed" Тогда
				ТелефонияСервер.ОбработатьЗавершениеЗвонка(
					,,,,,
					Ложь,,,
					ПараметрыТела.callid,,
					ПараметрыТела.ext
				);
			ИначеЕсли НРег(ПараметрыТела.type) = "cancelled" Тогда
				ТелефонияСервер.ОбработатьЗавершениеЗвонка(
					,,,,,
					Истина,,,
					ПараметрыТела.callid,,
					ПараметрыТела.ext
				);
			КонецЕсли;
			
		Иначе
			
			Возврат СообщениеОбОшибке(501, ИмяСобытияДляЖурналаРегистрации); // Not implemented
			
		КонецЕсли;
		
	Исключение
		
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));
		
	КонецПопытки;
	
	Если Ответ = Неопределено Тогда
		Ответ = Новый HTTPСервисОтвет(200);
	КонецЕсли;
	
	Возврат Ответ;
	
КонецФункции

Функция mangoEventsCallPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/events/call";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии Манго отключено в настройках'"));
	КонецЕсли;
	
	ТелоЗапроса = РаскодироватьСтроку(Запрос.ПолучитьТелоКакСтроку(), СпособКодированияСтроки.КодировкаURL);
	ПараметрыТела = СтроковыеФункцииКлиентСервер.ПолучитьПараметрыИзСтроки(ТелоЗапроса, "&");
	
	ТелефонияПереопределяемый.ЗаписатьЗапросВЖурналРегистрации(ИмяСобытияДляЖурналаРегистрации, ПараметрыТела.json);
	
	УстановитьПривилегированныйРежим(Истина);
	
	Если Не КорректныйКлюч(ПараметрыТела.sign, Перечисления.ДоступныеАТС.MangoOffice, ПараметрыТела) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Неверно указана подпись запроса sign=%1'"), ПараметрыТела.sign));
	КонецЕсли;
	
	ЧтениеJSON = Новый ЧтениеJSON;
	ЧтениеJSON.УстановитьСтроку(ПараметрыТела.json);
	МассивИмен = Новый Массив;
	МассивИмен.Добавить("timestamp");
	ПараметрыЗапросаJSON = ПрочитатьJSON(ЧтениеJSON,,,,"ВосстановлениеJSON",ТелефонияСервер,,МассивИмен);
	ЧтениеJSON.Закрыть();
	
	ОбязательныеПараметры = Новый Массив;
	ОбязательныеПараметры.Добавить("entry_id");
	ОбязательныеПараметры.Добавить("call_id");
	ОбязательныеПараметры.Добавить("timestamp");
	ОбязательныеПараметры.Добавить("seq");
	ОбязательныеПараметры.Добавить("call_state");
	ОбязательныеПараметры.Добавить("location");
	ОбязательныеПараметры.Добавить("to");
	ОбязательныеПараметры.Добавить("from");
	
	Для Каждого ОбязательныйПараметр Из ОбязательныеПараметры Цикл
		Если Не ПараметрыЗапросаJSON.Свойство(ОбязательныйПараметр) Тогда
			Возврат СообщениеОбОшибке(
				400,
				ИмяСобытияДляЖурналаРегистрации,
				СтрШаблон(НСтр("ru='Отсутствует обязательный параметр %1.'"), ОбязательныйПараметр));
		КонецЕсли;
	КонецЦикла;
	
	Попытка
		Если НРег(ПараметрыЗапросаJSON.location) = "abonent" Тогда
		
			Если ПараметрыЗапросаJSON.call_state = "Appeared" Тогда
				
				Если ПараметрыЗапросаJSON.from.Свойство("extension") И ПараметрыЗапросаJSON.to.Свойство("number") Тогда
					
					ТелефонияСервер.ОбработатьИсходящийЗвонок(
						ПараметрыЗапросаJSON.timestamp,
						ПараметрыЗапросаJSON.from.extension,,
						ПараметрыЗапросаJSON.to.number,
						ПараметрыЗапросаJSON.entry_id,
						ПараметрыЗапросаJSON.timestamp
					);
					
				ИначеЕсли ПараметрыЗапросаJSON.from.Свойство("number") И ПараметрыЗапросаJSON.to.Свойство("extension")
					И НЕ ПараметрыЗапросаJSON.Свойство("command_id") Тогда
					
					УстановитьПривилегированныйРежим(Истина);
					
					МенеджерЗаписи = РегистрыСведений.ДанныеЗвонков.СоздатьМенеджерЗаписи();
					МенеджерЗаписи.ИдентификаторЗвонкаВАТС = ПараметрыЗапросаJSON.entry_id;
					МенеджерЗаписи.Прочитать();
					
					РегистрироватьЗвонок = Ложь;
					
					Если НЕ МенеджерЗаписи.Выбран() Тогда
						МенеджерЗаписи.ИдентификаторЗвонкаВАТС = ПараметрыЗапросаJSON.entry_id;
						МенеджерЗаписи.Записать();
						
						РегистрироватьЗвонок = Истина;
						
					КонецЕсли;
					
					УстановитьПривилегированныйРежим(Ложь);
					
					ТелефонияСервер.ОбработатьВходящийЗвонок(
						ПараметрыЗапросаJSON.from.number,
						ПараметрыЗапросаJSON.to.extension,
						ПараметрыЗапросаJSON.timestamp,
						ПараметрыЗапросаJSON.entry_id,
						РегистрироватьЗвонок,
						Истина,
						ПараметрыЗапросаJSON.to.number
					);
					
				КонецЕсли;
				
			ИначеЕсли ПараметрыЗапросаJSON.call_state = "Connected" Тогда
				
				Если ПараметрыЗапросаJSON.to.Свойство("extension") Тогда
					Пользователь = ПараметрыЗапросаJSON.to.extension;
				ИначеЕсли ПараметрыЗапросаJSON.from.Свойство("extension") Тогда
					Пользователь = ПараметрыЗапросаJSON.from.extension;
				КонецЕсли;
				
				ТелефонияСервер.ОбработатьИзменениеЗвонка(
					ПараметрыЗапросаJSON.entry_id,
					ПараметрыЗапросаJSON.timestamp,
					Пользователь
				);
				
			ИначеЕсли ПараметрыЗапросаJSON.call_state = "Disconnected" Тогда
				
				Пользователь = Неопределено;
				Если ПараметрыЗапросаJSON.to.Свойство("extension") Тогда
					Пользователь = ПараметрыЗапросаJSON.to.extension;
				ИначеЕсли ПараметрыЗапросаJSON.from.Свойство("extension") Тогда
					Пользователь = ПараметрыЗапросаJSON.from.extension;
				КонецЕсли;
				
				ТелефонияСервер.ОбработатьЗавершениеЗвонка(
					,,,
					ПараметрыЗапросаJSON.timestamp,,
					,,,
					ПараметрыЗапросаJSON.entry_id,,
					Пользователь
				);
				
			КонецЕсли;
			
		КонецЕсли;
		
	Исключение
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));
	КонецПопытки;
	
	Ответ = Новый HTTPСервисОтвет(200);
	Возврат Ответ;
	
КонецФункции

Функция mangoEventsRecordingPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/events/recording";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии Манго отключено в настройках'"));
	КонецЕсли;
	
	ТелоЗапроса = РаскодироватьСтроку(Запрос.ПолучитьТелоКакСтроку(), СпособКодированияСтроки.КодировкаURL);
	ПараметрыТела = СтроковыеФункцииКлиентСервер.ПолучитьПараметрыИзСтроки(ТелоЗапроса, "&");
	
	ТелефонияПереопределяемый.ЗаписатьЗапросВЖурналРегистрации(ИмяСобытияДляЖурналаРегистрации, ПараметрыТела.json);
	
	УстановитьПривилегированныйРежим(Истина);
	
	Если Не КорректныйКлюч(ПараметрыТела.sign, Перечисления.ДоступныеАТС.MangoOffice, ПараметрыТела) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Неверно указана подпись запроса sign=%1'"), ПараметрыТела.sign));
	КонецЕсли;
	
	ЧтениеJSON = Новый ЧтениеJSON;
	ЧтениеJSON.УстановитьСтроку(ПараметрыТела.json);
	МассивИмен = Новый Массив;
	МассивИмен.Добавить("timestamp");
	ПараметрыЗапросаJSON = ПрочитатьJSON(ЧтениеJSON,,,,"ВосстановлениеJSON",ТелефонияСервер,,МассивИмен);
	ЧтениеJSON.Закрыть();
	
	ОбязательныеПараметры = Новый Массив;
	ОбязательныеПараметры.Добавить("recording_id");
	ОбязательныеПараметры.Добавить("recording_state");
	ОбязательныеПараметры.Добавить("seq");
	ОбязательныеПараметры.Добавить("entry_id");
	ОбязательныеПараметры.Добавить("call_id");
	ОбязательныеПараметры.Добавить("timestamp");
	
	Для Каждого ОбязательныйПараметр Из ОбязательныеПараметры Цикл
		Если Не ПараметрыЗапросаJSON.Свойство(ОбязательныйПараметр) Тогда
			Возврат СообщениеОбОшибке(
				400,
				ИмяСобытияДляЖурналаРегистрации,
				СтрШаблон(НСтр("ru='Отсутствует обязательный параметр %1.'"), ОбязательныйПараметр));
		КонецЕсли;
	КонецЦикла;
	
	НеобходимоОбработатьУведомление =
		ВРег(ПараметрыЗапросаJSON.recording_state) = ВРег("Completed")
		И ПараметрыЗапросаJSON.completion_code = 1000; // 1000 - Действие успешно выполнено
	
	Если НЕ НеобходимоОбработатьУведомление Тогда
		Ответ = Новый HTTPСервисОтвет(200);
		Возврат Ответ;
	КонецЕсли;
	
	Попытка
		ТелефонияСервер.ОбработатьЗавершениеЗвонка(,,,,,, ПараметрыЗапросаJSON.recording_id,, ПараметрыЗапросаJSON.entry_id);
	Исключение
		Возврат СообщениеОбОшибке(500,
			ИмяСобытияДляЖурналаРегистрации,
			ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));
	КонецПопытки;
	
	Ответ = Новый HTTPСервисОтвет(200);
	Возврат Ответ;
	
КонецФункции

Функция mangoResultCallbackPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/result/callback";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии отключено в настройках'"));
	КонецЕсли;
	
	Ответ = Новый HTTPСервисОтвет(501); // Not implemented
	Возврат Ответ;
	
КонецФункции

Функция mangoResultStatsPOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/result/stats";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии отключено в настройках'"));
	КонецЕсли;
	
	Ответ = Новый HTTPСервисОтвет(501); // Not implemented
	Возврат Ответ;
	
КонецФункции

Функция mangoResultRoutePOST(Запрос)
	
	ИмяСобытияДляЖурналаРегистрации = "/result/route";
	
	Если Не ПолучитьФункциональнуюОпцию("ИспользоватьОблачнуюТелефонию") Тогда
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			НСтр("ru='Использование телефонии отключено в настройках'"));
	КонецЕсли;
	
	Ответ = Новый HTTPСервисОтвет(501); // Not implemented
	Возврат Ответ;
	
КонецФункции

Функция yandexEventPOST(Запрос)
	
	ТелоЗапроса = РаскодироватьСтроку(Запрос.ПолучитьТелоКакСтроку(), СпособКодированияСтроки.КодировкаURL);
	
	ЗаголовкиОтвет = Новый Структура("Echo", Запрос.Заголовки.Получить("Echo"));
	
	Если НЕ ЗначениеЗаполнено(ТелоЗапроса) Тогда // Проверочный запрос при первом подключении webhook в личном кабинете.
		Возврат НовыйHTTPСервисОтвет(200, ЗаголовкиОтвет);
	КонецЕсли;
	
	ИмяСобытияДляЖурналаРегистрации = "/event";
	
	ТелефонияПереопределяемый.ЗаписатьЗапросВЖурналРегистрации(ИмяСобытияДляЖурналаРегистрации, ТелоЗапроса);
	
	ЧтениеJSON = Новый ЧтениеJSON;
	ЧтениеJSON.УстановитьСтроку(ТелоЗапроса);
	ПараметрыЗапроса = ПрочитатьJSON(ЧтениеJSON,, "Timestamp", ФорматДатыJSON.ISO);
	ЧтениеJSON.Закрыть();
	
	Если НЕ КорректныйКлюч(ПараметрыЗапроса.ApiKey, Перечисления.ДоступныеАТС.Яндекс) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Некорректный ApiKey'")),
			ЗаголовкиОтвет);
	КонецЕсли;
	
	ОбязательныеПараметры = "EventType";
	Если НЕ ЕстьОбязательныеПараметры(ПараметрыЗапроса, ОбязательныеПараметры) Тогда
		Возврат СообщениеОбОшибке(
			400,
			ИмяСобытияДляЖурналаРегистрации,
			СтрШаблон(НСтр("ru='Отсутствует обязательные параметры: %1'"), ОбязательныеПараметры),
			ЗаголовкиОтвет);
	КонецЕсли;
	
	ТипСобытия = ПараметрыЗапроса.EventType;
	
	Попытка
		
		// Появление нового входящего звонка со внешнего номера {From} на бизнес номер {To}
		Если ТипСобытия = "IncomingCall" Тогда
			
			ТелефонияСервер.ОбработатьВходящийЗвонок(
				ПараметрыЗапроса.Body.From,
				ПараметрыЗапроса.Body.To,
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Id,
				Истина,
				Ложь,
				ПараметрыЗапроса.Body.To);
			
		// Начало дозвона до пользователя с указанным добавочным номером {Extension}
		ИначеЕсли ТипСобытия = "IncomingCallRinging" Тогда
			
			ТелефонияСервер.ОбработатьВходящийЗвонок(
				ПараметрыЗапроса.Body.From,
				ПараметрыЗапроса.Body.Extension,
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Id,
				Ложь);
			
		// Неуспешная попытка дозвона до пользователя с добавочным номером {Extension}
		ИначеЕсли ТипСобытия = "IncomingCallStopRinging" Тогда 
			
		// Успешное соединение с пользователем с добавочным номером {Extension}
		ИначеЕсли ТипСобытия = "IncomingCallConnected" Тогда
			
			ТелефонияСервер.ОбработатьИзменениеЗвонка(
				ПараметрыЗапроса.Body.Id,
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Extension);
			
		// Завершение входящего звонка
		ИначеЕсли ТипСобытия = "IncomingCallCompleted" Тогда
			
			ТелефонияСервер.ОбработатьЗавершениеЗвонка(,,,
				ПараметрыЗапроса.Timestamp,,,,
				Истина,
				ПараметрыЗапроса.Body.Id);
			
		// Начало исходящего звонка с бизнес номера {From} на внешний номер {To} пользователем с добавочным номером {Extension}
		ИначеЕсли ТипСобытия = "OutgoingCall" Тогда
			
			ТелефонияСервер.ОбработатьИсходящийЗвонок(
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Extension,,
				ПараметрыЗапроса.Body.To,
				ПараметрыЗапроса.Body.Id);
			
		// Начало разговора при исходящем звонке
		ИначеЕсли ТипСобытия = "OutgoingCallConnected" Тогда
			
			ТелефонияСервер.ОбработатьИзменениеЗвонка(
				ПараметрыЗапроса.Body.Id,
				ПараметрыЗапроса.Timestamp,
				ПараметрыЗапроса.Body.Extension);
			
		// Завершение исходящего звонка
		ИначеЕсли ТипСобытия = "OutgoingCallCompleted" Тогда
			
			ТелефонияСервер.ОбработатьЗавершениеЗвонка(,,,
				ПараметрыЗапроса.Timestamp,,,,
				Истина,
				ПараметрыЗапроса.Body.Id);
			
		// Появление заявки на обратный звонок с бизнес номера {From} на внешний номер {To}
		ИначеЕсли ТипСобытия = "CallbackCall" Тогда
			
		// Начало дозвона до пользователя с указанным добавочным номером {Extension} при обратном звонке
		ИначеЕсли ТипСобытия = "CallbackCallRinging" Тогда
			
		// Неуспешная попытка дозвона до пользователя с добавочным номером {Extension} при обратном звонке
		ИначеЕсли ТипСобытия = "CallbackCallStopRinging" Тогда
			
		// Пользователь с добавочным номером {Extension} соединился с номером {To} при обратном звонке
		ИначеЕсли ТипСобытия = "CallbackCallConnected" Тогда
			
		// Завершение обратного звонка
		ИначеЕсли ТипСобытия = "CallbackCallCompleted" Тогда
			
		КонецЕсли;
		
	Исключение
		Возврат СообщениеОбОшибке(
			500,
			ИмяСобытияДляЖурналаРегистрации,
			ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()),
			ЗаголовкиОтвет);
	КонецПопытки;
	
	Возврат НовыйHTTPСервисОтвет(200, ЗаголовкиОтвет);
	
КонецФункции

#КонецОбласти

#Область СлужебныеПроцедурыИФункции

Функция ПолучитьПараметрыИзСтроки(Знач СтрокаПараметров, Знач Разделитель = ";") Экспорт
	Результат = Новый Структура;
	
	ОписаниеПараметра = "";
	НайденоНачалоСтроки = Ложь;
	НомерПоследнегоСимвола = СтрДлина(СтрокаПараметров);
	Для НомерСимвола = 1 По НомерПоследнегоСимвола Цикл
		Символ =Сред(СтрокаПараметров, НомерСимвола, 1);
		Если Символ = """" Тогда
			НайденоНачалоСтроки = Не НайденоНачалоСтроки;
		КонецЕсли;
		Если Символ <> Разделитель Или НайденоНачалоСтроки Тогда
			ОписаниеПараметра = ОписаниеПараметра + Символ;
		КонецЕсли;
		Если Символ = Разделитель И Не НайденоНачалоСтроки Или НомерСимвола = НомерПоследнегоСимвола Тогда
			Позиция = СтрНайти(ОписаниеПараметра, "=");
			Если Позиция > 0 Тогда
				ИмяПараметра = СокрЛП(Лев(ОписаниеПараметра, Позиция - 1));
				ЗначениеПараметра = СокрЛП(Сред(ОписаниеПараметра, Позиция + 1));
				ЗначениеПараметра = СтроковыеФункцииКлиентСервер.СократитьДвойныеКавычки(ЗначениеПараметра);
				Попытка
					Результат.Вставить(ИмяПараметра, ЗначениеПараметра);
				Исключение
				КонецПопытки;
			КонецЕсли;
			ОписаниеПараметра = "";
		КонецЕсли;
	КонецЦикла;
	
	Возврат Результат;
КонецФункции

Функция КорректныйКлюч(Ключ, АТС, ПараметрыЗапроса = Неопределено)
	
	Если АТС = Перечисления.ДоступныеАТС.MangoOffice Тогда
		
		УстановитьПривилегированныйРежим(Истина);
		НастройкиТелефонии = ТелефонияСервер.ПолучитьНастройкиТелефонии();
		РассчитанныйSign = ТелефонияСервер.ПолучитьSign(
			НастройкиТелефонии.vpbx_api_key,
			ПараметрыЗапроса.json,
			НастройкиТелефонии.vpbx_api_salt
		);
		
		Возврат РассчитанныйSign = Ключ;
		
	ИначеЕсли АТС = Перечисления.ДоступныеАТС.Яндекс Тогда
		
		УстановитьПривилегированныйРежим(Истина);
		КлючДляАвторизации = ТелефонияСервер.ПолучитьНастройкиТелефонии().КлючДляАвторизацииАТСЯндекс;
		Возврат Ключ = КлючДляАвторизации;
		
	ИначеЕсли ТелефонияПереопределяемый.ЭтоПлатформаItoolabs(АТС) Тогда
		
		УстановитьПривилегированныйРежим(Истина);
		КлючДляАвторизации = ТелефонияСервер.ПолучитьНастройкиТелефонии().КлючДляАвторизацииВУНФ;
		Возврат Ключ = КлючДляАвторизации;
		
	КонецЕсли;
	
КонецФункции

Функция ЕстьОбязательныеПараметры(ПараметрыТела, ОбязательныеПараметры)
	
	МассивПараметров = СтроковыеФункцииКлиентСервер.РазложитьСтрокуВМассивПодстрок(ОбязательныеПараметры);
	
	Для Каждого ОбязательныйПараметр Из МассивПараметров Цикл
		Если НЕ ПараметрыТела.Свойство(ОбязательныйПараметр) Тогда
			Возврат Ложь;
		КонецЕсли;
	КонецЦикла;
	
	Возврат Истина;
	
КонецФункции

Функция СообщениеОбОшибке(КодСостояния, ВложенноеИмяСобытия, Комментарий = Неопределено, Заголовки = Неопределено)
	
	ЗаписьЖурналаРегистрации(
		ТелефонияПереопределяемый.СобытиеЖурналаРегистрации() + "." + ВложенноеИмяСобытия,
		УровеньЖурналаРегистрации.Ошибка,,,
		Комментарий);
	
	Возврат НовыйHTTPСервисОтвет(КодСостояния, Заголовки);
	
КонецФункции

Функция НовыйHTTPСервисОтвет(КодСостояния, Заголовки = Неопределено)
	
	Ответ = Новый HTTPСервисОтвет(КодСостояния);
	
	Если Заголовки <> Неопределено Тогда
		ОбщегоНазначенияКлиентСервер.ДополнитьСоответствие(Ответ.Заголовки, Заголовки);
	КонецЕсли;
	
	Возврат Ответ;
	
КонецФункции

#КонецОбласти
