﻿
#Область ОбработчикиМетодов

Функция ЗаписатьДанные(КодМобильногоКомпьютера, ДанныеМобильногоПриложения)
	
	УстановитьПривилегированныйРежим(Истина);
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.НайтиПоКоду(КодМобильногоКомпьютера); 
	
	Если УзелОбмена.Пустая() Тогда
		ВызватьИсключение(НСтр("ru='Неизвестное устройство - '") + КодМобильногоКомпьютера);
	КонецЕсли;
	
	ОбменМобильноеПриложениеОбщее.ОбработатьПринятыйПакетЗагрузки(УзелОбмена, ДанныеМобильногоПриложения, Истина);
	
КонецФункции

Функция ПолучитьДанные(КодМобильногоКомпьютера)
	
	УстановитьПривилегированныйРежим(Истина);
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.НайтиПоКоду(КодМобильногоКомпьютера); 
	
	Если УзелОбмена.Пустая() Тогда
		ВызватьИсключение(НСтр("ru='Неизвестное устройство - '") + КодМобильногоКомпьютера);
	КонецЕсли;
	
	Возврат ОбменМобильноеПриложениеОбщее.СформироватьЕдиныйПакетВыгрузки(УзелОбмена);
	
КонецФункции

Функция ПолучитьПакетОбмена(КодМобильногоКомпьютера, НомерСообщенияОбмена, ИдентификаторЗадания)
	
	Попытка
		
		УстановитьПривилегированныйРежим(Истина);
		
		УзелОбмена = ПланыОбмена.МобильноеПриложение.НайтиПоКоду(КодМобильногоКомпьютера); 
		
		Если УзелОбмена.Пустая() Тогда
			ВызватьИсключение(НСтр("ru='Неизвестное устройство - '") + КодМобильногоКомпьютера);
		КонецЕсли;
		
		Возврат ОбменМобильноеПриложениеОбщее.ПолучитьСообщениеОбмена(УзелОбмена, НомерСообщенияОбмена, ИдентификаторЗадания);
		
	Исключение
		
		ПредставлениеОшибки = ПодробноеПредставлениеОшибки(ИнформацияОбОшибке());
		
		ЗаписьЖурналаРегистрации(НСтр("ru = 'Обмен данными с мобильный приложением. Получение пакета обмена.'"),
			УровеньЖурналаРегистрации.Ошибка,,, ПредставлениеОшибки);
		ВызватьИсключение ПредставлениеОшибки;
		
	КонецПопытки;
	
КонецФункции

Функция ОтправитьПакетОбменаВСервис(ДанныеМобильногоПриложения, КодМобильногоКомпьютера, НаименованиеМобильногоКомпьютера, НомерОтправленного, НомерПринятого, ПериодВыгрузки, ВерсияМобильногоПриложения)
	
	СтруктураОтвета = Новый Структура("ИдентификаторЗадания, НовыйОбмен", Неопределено, Ложь);
	
	Пользователь = Пользователи.АвторизованныйПользователь();
	ПроверитьПраваПользователя(Пользователь);
	ПроверитьДоступУстройства(КодМобильногоКомпьютера);
	
	УстановитьПривилегированныйРежим(Истина);
	
	ПериодВыгрузкиВМобильноеПриложениеУстановленный = УправлениеНебольшойФирмойПовтИсп.ПолучитьЗначениеПоУмолчаниюПользователя(
		Пользователь,
		"ПериодВыгрузкиВМобильноеПриложение"
	);

	Если ПериодВыгрузки = "За последний квартал" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнийКвартал;
	ИначеЕсли ПериодВыгрузки = "За последний месяц" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнийМесяц;
	ИначеЕсли ПериодВыгрузки = "За последнюю неделю" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнююНеделю;
	ИначеЕсли ПериодВыгрузки = "За последний день" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнийДень;
	Иначе
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаВсеВремя;
	КонецЕсли;
	
	Если ПериодВыгрузкиВМобильноеПриложениеУстановленный <> ПериодВыгрузкиВМобильноеПриложение Тогда
		УправлениеНебольшойФирмойСервер.УстановитьНастройкуПользователя(ПериодВыгрузкиВМобильноеПриложение, "ПериодВыгрузкиВМобильноеПриложение")
	КонецЕсли;
	
	СтруктураОтбора = Новый Структура("Наименование", КодМобильногоКомпьютера);
	МассивЗаданий = ФоновыеЗадания.ПолучитьФоновыеЗадания(СтруктураОтбора);
	ЕстьАктивноеЗадание = Ложь;
	Для Каждого ФоновоеЗадание Из МассивЗаданий Цикл
		Если ФоновоеЗадание.Состояние = СостояниеФоновогоЗадания.Активно Тогда
			ФоновоеЗадание.Отменить();
		КонецЕсли;
	КонецЦикла;
		
	УзелОбмена = ПланыОбмена.МобильноеПриложение.ЭтотУзел().ПолучитьОбъект();
	Если НЕ ЗначениеЗаполнено(УзелОбмена.Код) Тогда
		
		УзелОбмена.ОбменДанными.Загрузка = Истина;
		УзелОбмена.Код = "001";
		УзелОбмена.Наименование = "Центральный";
		УзелОбмена.Записать();
		
	КонецЕсли;
	
	НужнаИнициализацияУзла = Ложь;
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.НайтиПоКоду(КодМобильногоКомпьютера); 
	Если УзелОбмена.Пустая() Тогда
		
		ПроверитьВозможностьДобавленияновогоУзла();
		
		НовыйУзел = ПланыОбмена.МобильноеПриложение.СоздатьУзел();
		НовыйУзел.Код = КодМобильногоКомпьютера;
		НовыйУзел.Наименование = ПолучитьНаименованиеНовогоУзла(НаименованиеМобильногоКомпьютера);
		НовыйУзел.ВерсияМобильногоПриложения = ВерсияМобильногоПриложения;
		НовыйУзел.НомерОтправленного = НомерОтправленного;
		НовыйУзел.НомерПринятого = НомерПринятого;
		НовыйУзел.ДатаПоследнейСинхронизации = ТекущаяДатаСеанса();
		НовыйУзел.КассаККМ = СоздатьКассуККМ(НовыйУзел.Наименование);
		
		ПрофильПользователя = РегистрыСведений.ПрофилиМобильныхПользователей.ПолучитьПрофильПользователя(Пользователь);
		Если ЗначениеЗаполнено(ПрофильПользователя) Тогда
			НовыйУзел.УстановитьРолиПоПрофилю(ПрофильПользователя); 
		Иначе
			НовыйУзел.УстановитьРолиПоПрофилю(Перечисления.ПрофилиМобильногоПриложения.Собственник); // Новый узел всегда создается с правами собственника.
		КонецЕсли;
		Если ОбменМобильноеПриложениеОбщее.ЭтоВерсияСоСтарымОбменом(НовыйУзел) Тогда
			НовыйУзел.ПоОтветственному = Истина;
		КонецЕсли;
		
		НовыйУзел.Записать();
		УзелОбмена = НовыйУзел.Ссылка;
		НужнаИнициализацияУзла = Истина;
		
	Иначе
		
		Узел = УзелОбмена.ПолучитьОбъект();
		
		Если Узел.ПометкаУдаления ИЛИ
			Узел.Наименование <> НаименованиеМобильногоКомпьютера ИЛИ
			Узел.ВерсияМобильногоПриложения <> ВерсияМобильногоПриложения Тогда
			Узел.ПометкаУдаления = Ложь;
			Узел.ВерсияМобильногоПриложения = ВерсияМобильногоПриложения;
		КонецЕсли;
		
		Если НЕ ЗначениеЗаполнено(Узел.КассаККМ) Тогда
			Узел.КассаККМ = СоздатьКассуККМ(Узел.Наименование);
		КонецЕсли;
		
		Если Узел.Роли.Количество() = 0 Тогда // Если роли незаполнены, то это старый узел, соответсвующий торговому представителю.
			Узел.УстановитьРолиПоПрофилю(Перечисления.ПрофилиМобильногоПриложения.ТорговыйПредставитель);
		КонецЕсли;
		
		Если Узел.НомерОтправленного = 0
			ИЛИ Узел.НомерПринятого = 0
			ИЛИ Узел.НомерОтправленного < НомерПринятого
			ИЛИ Узел.НомерПринятого <> НомерОтправленного Тогда
			Узел.НомерОтправленного = НомерПринятого;
			Узел.НомерПринятого = НомерОтправленного;
			НужнаИнициализацияУзла = Истина;
		КонецЕсли;
		
		Узел.ДатаПоследнейСинхронизации = ТекущаяДатаСеанса();
		Узел.Записать();
		
	КонецЕсли;
	
	ОбменМобильноеПриложениеОбщее.ОбработатьПринятыйПакетЗагрузки(УзелОбмена, ДанныеМобильногоПриложения, Ложь, Истина);
	ОбменМобильноеПриложениеОбщее.ЗапуститьФормированиеОчередиСообщенийОбмена(УзелОбмена, КодМобильногоКомпьютера, НомерПринятого, НужнаИнициализацияУзла, СтруктураОтвета.ИдентификаторЗадания, Истина);
	СтруктураОтвета.НовыйОбмен = НужнаИнициализацияУзла;
	
	Возврат Новый ХранилищеЗначения(СтруктураОтвета, Новый СжатиеДанных(9));
	
КонецФункции

Функция ДобавитьПользователя(ПочтаПользователя, ПарольПользователяСервиса, ПрофильПользователя)
	
	НачатьТранзакцию();
	
	НовыйПользователь = Справочники.Пользователи.СоздатьЭлемент();
	НовыйПользователь.Наименование = ПочтаПользователя;
	СтруктураАдресаЭП = ПолучитьСтруктуруАдресаЭлектроннойПочты(ПочтаПользователя);
	ОбновитьАдресЭлектроннойПочты(НовыйПользователь, ПочтаПользователя, СтруктураАдресаЭП);
	
	ОписаниеПользователяИБ = Пользователи.НовоеОписаниеПользователяИБ();
	ОписаниеПользователяИБ.Имя = ПочтаПользователя;
	ОписаниеПользователяИБ.АутентификацияСтандартная = Истина;
	ОписаниеПользователяИБ.АутентификацияOpenID = Истина;
	ОписаниеПользователяИБ.ПоказыватьВСпискеВыбора = Ложь;
	ОписаниеПользователяИБ.Вставить("Действие", "Записать");
	ОписаниеПользователяИБ.Вставить("ВходВПрограммуРазрешен", Истина);
	ОписаниеПользователяИБ.Пароль = "" + Новый УникальныйИдентификатор + "qQ";
	
	НовыйПользователь.ДополнительныеСвойства.Вставить("ОписаниеПользователяИБ", ОписаниеПользователяИБ);
	НовыйПользователь.ДополнительныеСвойства.Вставить("ПарольПользователяСервиса", ПарольПользователяСервиса);
	НовыйПользователь.ДополнительныеСвойства.Вставить("СинхронизироватьССервисом", Истина);
	НовыйПользователь.Записать();
	
	ГруппаДоступа = Справочники.ГруппыДоступа.Администраторы.ПолучитьОбъект();
	ПользовательГруппы = ГруппаДоступа.Пользователи.Добавить();
	ПользовательГруппы.Пользователь = НовыйПользователь.Ссылка;
	ГруппаДоступа.ДополнительныеСвойства.Вставить("ПарольПользователяСервиса", ПарольПользователяСервиса);
	ГруппаДоступа.Записать();
	
	РегистрыСведений.ПрофилиМобильныхПользователей.НазначитьПрофильПользователю(НовыйПользователь.Ссылка, ПрофильПользователя);
	
	ЗафиксироватьТранзакцию();
	
	Возврат НСтр("ru='Пользователю успешно отправлено приглашение на электронный адрес.'");
	
КонецФункции

Функция ОбновитьДанныеПользователя(ПочтаПользователя, ПарольПользователяСервиса, ПрофильПользователя, ВходРазрешен)
	
	НачатьТранзакцию();
	
	Пользователь = Справочники.Пользователи.НайтиПоНаименованию(ПочтаПользователя, Истина);
	
	Если НЕ ЗначениеЗаполнено(Пользователь) Тогда
		Возврат НСтр("ru='Пользователь не найден.'");
	КонецЕсли;
	
	ОписаниеПользователяИБ = Неопределено;
	Пользователи.ПрочитатьПользователяИБ(Пользователь.ИдентификаторПользователяИБ, ОписаниеПользователяИБ);
	
	Если ВходРазрешен Тогда
		ОписаниеПользователяИБ.АутентификацияСтандартная = Истина;
		ОписаниеПользователяИБ.АутентификацияOpenID = Истина;
	Иначе
		ОписаниеПользователяИБ.АутентификацияСтандартная = Ложь;
		ОписаниеПользователяИБ.АутентификацияOpenID = Ложь;
	КонецЕсли;
	
	ОписаниеПользователяИБ.Вставить("Действие", "Записать");
	ПользовательОбъект = Пользователь.ПолучитьОбъект();
	ПользовательОбъект.ДополнительныеСвойства.Вставить("ОписаниеПользователяИБ", ОписаниеПользователяИБ);
	ПользовательОбъект.ДополнительныеСвойства.Вставить("ПарольПользователяСервиса", ПарольПользователяСервиса);
	ПользовательОбъект.ДополнительныеСвойства.Вставить("СинхронизироватьССервисом", Истина);
	ПользовательОбъект.Записать();
	
	РегистрыСведений.ПрофилиМобильныхПользователей.НазначитьПрофильПользователю(Пользователь, ПрофильПользователя);
	
	ЗафиксироватьТранзакцию();
	
	Возврат НСтр("ru='Параметры пользователя успешно изменены.'");
	
КонецФункции

Функция ПолучитьСписокПользователей()
	
	Запрос = Новый Запрос();
	
	Запрос.Текст =
	"ВЫБРАТЬ
	|	Пользователи.ИдентификаторПользователяИБ,
	|	Пользователи.Наименование,
	|	Пользователи.Недействителен,
	|	Пользователи.Ссылка
	|ИЗ
	|	Справочник.Пользователи КАК Пользователи
	|ГДЕ
	|	НЕ Пользователи.Служебный
	|	И Пользователи.ИдентификаторПользователяИБ <> &ПустойИД";
	
	Запрос.УстановитьПараметр("ПустойИД", Новый УникальныйИдентификатор("00000000-0000-0000-0000-000000000000"));
	Выборка = Запрос.Выполнить().Выбрать();
	
	МассивПользователей = Новый Массив();
	
	Пока Выборка.Следующий() Цикл
		Профиль = РегистрыСведений.ПрофилиМобильныхПользователей.ПолучитьПрофильПользователя(Выборка.Ссылка);
		ВходВПрограммуРазрешен = Пользователи.ВходВПрограммуРазрешен(Выборка.ИдентификаторПользователяИБ);
		МассивПользователей.Добавить(
			Новый Структура("Наименование, ИдентификаторПользователяИБ, Недействителен, ВходВПрограммуРазрешен, Профиль",
			Выборка.Наименование,
			Выборка.ИдентификаторПользователяИБ,
			Выборка.Недействителен,
			ВходВПрограммуРазрешен,
			Перечисления.ПрофилиМобильногоПриложения.ПолучитьСтроковоеПредставление(Профиль))
		);
	КонецЦикла;
	
	МассивXDTO = СериализаторXDTO.ЗаписатьXDTO(МассивПользователей);
	Возврат МассивXDTO;
	
КонецФункции

Функция УведомитьОЗвонке(НомерТелефона, Дата, ВариантСобытия, ТипЗвонка)
	
	// ВариантСобытия:
	// "ЗавершениеВходящего" / "EndIncoming"
	// "ЗавершениеИсходящего" / "EndOutgoing"
	// "НачалоВходящего" / "StartIncoming"
	// "НачалоИсходящего" / "StartOutgoing"
	// "НачалоСигналаВходящего" / "StartIncomingRinging"
	//
	// ТипЗвонка:
	// "Входящий" / "Incoming"
	// "Исходящий" / "Outgoing"
	// "Пропущенный" / "Missed"
	
	ТелефонияСервер.ОбработатьЗвонок(
		НомерТелефона,
		Пользователи.ТекущийПользователь(),
		Дата,
		ТипЗвонка,
		ВариантСобытия
	);
	
	Возврат "Sucsessful";
	
КонецФункции

Процедура УстановитьПрофильПоУмолчанию(НовыйУзел, Пользователь)
	
	ПрофильПользователя = РегистрыСведений.ПрофилиМобильныхПользователей.ПолучитьПрофильПользователя(Пользователь);
	Если ЗначениеЗаполнено(ПрофильПользователя) Тогда
		НовыйУзел.УстановитьРолиПоПрофилю(ПрофильПользователя);
		Если ПрофильПользователя = Перечисления.ПрофилиМобильногоПриложения.Собственник Тогда
			НовыйУзел.ПоВсемКассамККМ = Истина;
		КонецЕсли;
	Иначе
		Если РольДоступна(Метаданные.Роли.ПолныеПрава) Тогда
			НовыйУзел.УстановитьРолиПоПрофилю(Перечисления.ПрофилиМобильногоПриложения.Собственник);
			НовыйУзел.ПоВсемКассамККМ = Истина;
		Иначе
			НовыйУзел.УстановитьРолиПоПрофилю(Перечисления.ПрофилиМобильногоПриложения.ДетальнаяНастройка);
			Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеКонтрагентов) Тогда
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.КонтрагентыПросмотрИРедактирование);
			Конецесли;
			Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеНоменклатуры) Тогда
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.НоменклатураПросмотрИРедактирование);
			Конецесли;
			Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыПродажи) Тогда
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ЗаказыПросмотрИРедактирование);
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ДвиженияТоваровПросмотрИРедактирование);
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетОстаткиТоваровНаСкладахПросмотр);
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетПродажиПросмотр);
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетДолгиПросмотр);
				Если НЕ РольДоступна(Метаданные.Роли.ДобавлениеИзменениеНоменклатуры) Тогда
					НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.НоменклатураТолькоПросмотр);
				КонецЕсли;
			Конецесли;
			Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыЗакупки) Тогда
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ДвиженияТоваровПросмотрИРедактирование);
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетОстаткиТоваровНаСкладахПросмотр);
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетДолгиПросмотр);
				Если НЕ РольДоступна(Метаданные.Роли.ДобавлениеИзменениеНоменклатуры) Тогда
					НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.НоменклатураТолькоПросмотр);
				КонецЕсли;
			Конецесли;
			Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыКасса)
				ИЛИ РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыБанк) Тогда
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ДвиженияДенегПросмотрИРедактирование);
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетДвиженияДенегПросмотр);
				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетДолгиПросмотр);
			Конецесли;
		КонецЕсли;
	КонецЕсли;
	
КонецПроцедуры

Функция ОтправитьПакетОбменаВСервисСИдентификатором(ДанныеМобильногоПриложения, КодМобильногоКомпьютера, НаименованиеМобильногоКомпьютера, НомерОтправленного, НомерПринятого, ПериодВыгрузки, ВерсияМобильногоПриложения, ИДПодписчика)
	
	Попытка
		
		СтруктураОтвета = Новый Структура("ИдентификаторЗадания, НовыйОбмен", Неопределено, Ложь);
		
		Пользователь = Пользователи.АвторизованныйПользователь();
		ПроверитьДоступУстройства(КодМобильногоКомпьютера);

		УстановитьПривилегированныйРежим(Истина);
		
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаВсеВремя;
		ПериодВыгрузкиВМобильноеПриложениеУстановленный = УправлениеНебольшойФирмойПовтИсп.ПолучитьЗначениеПоУмолчаниюПользователя(
			Пользователь,
			"ПериодВыгрузкиВМобильноеПриложение"
		);

		Если ПериодВыгрузкиВМобильноеПриложениеУстановленный <> ПериодВыгрузкиВМобильноеПриложение Тогда
			УправлениеНебольшойФирмойСервер.УстановитьНастройкуПользователя(ПериодВыгрузкиВМобильноеПриложение, "ПериодВыгрузкиВМобильноеПриложение")
		КонецЕсли;
		
		СтруктураОтбора = Новый Структура("Наименование", КодМобильногоКомпьютера);
		МассивЗаданий = ФоновыеЗадания.ПолучитьФоновыеЗадания(СтруктураОтбора);
		ЕстьАктивноеЗадание = Ложь;
		Для каждого ФоновоеЗадание Из МассивЗаданий Цикл
			Если ФоновоеЗадание.Состояние = СостояниеФоновогоЗадания.Активно Тогда
				ФоновоеЗадание.Отменить();
			КонецЕсли;
		КонецЦикла;
		
		УзелОбмена = ПланыОбмена.МобильноеПриложение.ЭтотУзел().ПолучитьОбъект();
		Если НЕ ЗначениеЗаполнено(УзелОбмена.Код) Тогда
			УзелОбмена.ОбменДанными.Загрузка = Истина;
			УзелОбмена.Код = "001";
			УзелОбмена.Наименование = "Центральный";
			УзелОбмена.Записать();
		КонецЕсли;
		
		НужнаИнициализацияУзла = Ложь;
		
		УзелОбмена = ПланыОбмена.МобильноеПриложение.НайтиПоКоду(КодМобильногоКомпьютера); 
		Если УзелОбмена.Пустая() Тогда
			
			ПроверитьВозможностьДобавленияновогоУзла();
			
			НовыйУзел = ПланыОбмена.МобильноеПриложение.СоздатьУзел();
			НовыйУзел.Код = КодМобильногоКомпьютера;
			НовыйУзел.Наименование = ПолучитьНаименованиеНовогоУзла(НаименованиеМобильногоКомпьютера);
			НовыйУзел.ВерсияМобильногоПриложения = ВерсияМобильногоПриложения;
			НовыйУзел.НомерОтправленного = НомерОтправленного;
			НовыйУзел.НомерПринятого = НомерПринятого;
			НовыйУзел.ДатаПоследнейСинхронизации = ТекущаяДатаСеанса();
			НовыйУзел.КассаККМ = СоздатьКассуККМ(НовыйУзел.Наименование);
			
			УстановитьПрофильПоУмолчанию(НовыйУзел, Пользователь);
			
			Если ОбменМобильноеПриложениеОбщее.ЭтоВерсияСоСтарымОбменом(НовыйУзел) Тогда
				НовыйУзел.ПоОтветственному = Истина;
			КонецЕсли;
			
			Если ИДПодписчика <> Неопределено Тогда
				НовыйУзел.ИДПодписчика = Новый ХранилищеЗначения(ИДПодписчика);
			КонецЕсли;
			
			НовыйУзел.Записать();
			УзелОбмена = НовыйУзел.Ссылка;
			НужнаИнициализацияУзла = Истина;
			
		Иначе
			
			Узел = УзелОбмена.ПолучитьОбъект();
			
			Если УзелОбмена.ПометкаУдаления ИЛИ
				УзелОбмена.Наименование <> НаименованиеМобильногоКомпьютера ИЛИ
				УзелОбмена.ВерсияМобильногоПриложения <> ВерсияМобильногоПриложения ИЛИ
				(ИДПодписчика <> Неопределено И УзелОбмена.ИДПодписчика.Получить() = Неопределено) Тогда
				Узел.ПометкаУдаления = Ложь;
				Узел.ВерсияМобильногоПриложения = ВерсияМобильногоПриложения;
				Если ИДПодписчика <> Неопределено Тогда
					Узел.ИДПодписчика = Новый ХранилищеЗначения(ИДПодписчика);
				КонецЕсли;
			КонецЕсли;
			
			Если УзелОбмена.Роли.Количество() = 0 Тогда // Если роли незаполнены, то это старый узел, соответсвующий торговому представителю.
				Узел.УстановитьРолиПоПрофилю(Перечисления.ПрофилиМобильногоПриложения.ТорговыйПредставитель);
			КонецЕсли;
			
			Если УзелОбмена.НомерОтправленного = 0
				ИЛИ УзелОбмена.НомерПринятого = 0
				ИЛИ УзелОбмена.НомерОтправленного < НомерПринятого
				ИЛИ УзелОбмена.НомерПринятого <> НомерОтправленного Тогда
				Узел.НомерОтправленного = НомерПринятого;
				Узел.НомерПринятого = НомерОтправленного;
				НужнаИнициализацияУзла = Истина;
			КонецЕсли;
			
			Если НЕ ЗначениеЗаполнено(Узел.КассаККМ) Тогда
				Узел.КассаККМ = СоздатьКассуККМ(Узел.Наименование);
			КонецЕсли;
			
			Если УзелОбмена.Профиль = Перечисления.ПрофилиМобильногоПриложения.МобильнаяТелефония Тогда // Если у существующего узла профиль телефония, то нужноповторно зарегистрировать все изменения и выгрузить.
				УстановитьПрофильПоУмолчанию(УзелОбмена, Пользователь);
				НужнаИнициализацияУзла = Истина;
			КонецЕсли;
			
			Узел.ДатаПоследнейСинхронизации = ТекущаяДатаСеанса();
			Узел.Записать();
			
		КонецЕсли;
		
		ОбменМобильноеПриложениеОбщее.ОбработатьПринятыйПакетЗагрузки(УзелОбмена, ДанныеМобильногоПриложения, Ложь, Истина);
		ОбменМобильноеПриложениеОбщее.ЗапуститьФормированиеОчередиСообщенийОбмена(УзелОбмена, КодМобильногоКомпьютера, НомерПринятого, НужнаИнициализацияУзла, СтруктураОтвета.ИдентификаторЗадания, Истина);
		СтруктураОтвета.НовыйОбмен = НужнаИнициализацияУзла;
		
		Возврат Новый ХранилищеЗначения(СтруктураОтвета, Новый СжатиеДанных(9));
		
	Исключение
		
		ПредставлениеОшибки = ПодробноеПредставлениеОшибки(ИнформацияОбОшибке());
		
		ЗаписьЖурналаРегистрации(НСтр("ru = 'Обмен данными с мобильный приложением. Отправка пакета обмена.'"),
			УровеньЖурналаРегистрации.Ошибка,,, ПредставлениеОшибки);
		ВызватьИсключение ПредставлениеОшибки;
		
	КонецПопытки;
	
КонецФункции

Функция ПолучитьФотоТовара(Номенклатура)
	
	УстановитьПривилегированныйРежим(Истина);
	
	Идентификатор = Новый УникальныйИдентификатор(Номенклатура);
	Ссылка = Справочники.Номенклатура.ПолучитьСсылку(Идентификатор);
	
	Возврат ОбменМобильноеПриложениеОбщее.ПолучитьКартинку(Ссылка);
	
КонецФункции

Функция ЭтоМобильныйТарифныйПлан()
	
	УстановитьПривилегированныйРежим(Истина);
	ЭтоМобильноеПриложение = Константы.ЭтоМобильноеПриложение.Получить();
	Возврат ЭтоМобильноеПриложение;
	
КонецФункции

Функция ПолучитьКоличествоУстройств()
	
	УстановитьПривилегированныйРежим(Истина);
	Запрос = Новый Запрос();
	Запрос.Текст =
	"ВЫБРАТЬ
	|	КОЛИЧЕСТВО(МобильноеПриложение.Ссылка) КАК КоличествоУзлов
	|ИЗ
	|	ПланОбмена.МобильноеПриложение КАК МобильноеПриложение
	|ГДЕ
	|	НЕ МобильноеПриложение.ПометкаУдаления
	|	И НЕ МобильноеПриложение.ДоступЗапрещен
	|	И НЕ МобильноеПриложение.ЭтотУзел";
	Выборка = Запрос.Выполнить().Выбрать();
	Если Выборка.Следующий() Тогда
		Возврат Строка(Выборка.КоличествоУзлов);
	Иначе
		Возврат "0";
	КонецЕсли;
	
КонецФункции

Функция ПолучитьВерсиюПриложения()
	
	УстановитьПривилегированныйРежим(Истина);
	Возврат Строка(Метаданные.Версия);
	
КонецФункции

#КонецОбласти

#Область СлужебныеПроцедурыИФункции

Процедура ПроверитьПраваПользователя(Пользователь = Неопределено)
	
	Если Пользователь = Неопределено Тогда
		Пользователь = Пользователи.АвторизованныйПользователь();
	КонецЕсли;
	
	Если НЕ РольДоступна(Метаданные.Роли.ПолныеПрава)
	   И НЕ(РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыПродажи) // Профиль Базовые права.
		  И РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыКасса)
		  И РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыБанк)) Тогда // Профиль Деньги.
		
		ВызватьИсключение(
			НСтр("ru='У пользователя ""'")
		  + Пользователь
		  + НСтр("ru='"" нет прав на синхронизацию данных с мобильным приложением 1С:Управление нашей фирмой. Необходимо включить профили прав доступа Базовые права и Деньги.'")
		);
		
	КонецЕсли;
	
КонецПроцедуры

Процедура ПроверитьДоступУстройства(КодМобильногоКомпьютера)
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.НайтиПоКоду(КодМобильногоКомпьютера); 
	Если УзелОбмена.ДоступЗапрещен Тогда
		ВызватьИсключение(
			НСтр("ru='Устройству запрещена синхронизация с центральной базой.'")
		);
	КонецЕсли;
	
КонецПроцедуры

Функция ПолучитьНаименованиеНовогоУзла(ПредлагаемоеНаименование)
	
	Запрос = Новый Запрос;
	Запрос.Текст = 
	"ВЫБРАТЬ
	|	МобильноеПриложение.Наименование КАК Наименование
	|ИЗ
	|	ПланОбмена.МобильноеПриложение КАК МобильноеПриложение
	|ГДЕ
	|	МобильноеПриложение.Наименование ПОДОБНО &ПредлагаемоеНаименование
	|
	|УПОРЯДОЧИТЬ ПО
	|	Наименование УБЫВ";
	Запрос.УстановитьПараметр("ПредлагаемоеНаименование", ПредлагаемоеНаименование + " #%");
	
	РезультатЗапроса = Запрос.Выполнить();
	
	Если РезультатЗапроса.Пустой() Тогда
		Запрос.Текст =
		"ВЫБРАТЬ
		|	МобильноеПриложение.Наименование КАК Наименование
		|ИЗ
		|	ПланОбмена.МобильноеПриложение КАК МобильноеПриложение
		|ГДЕ
		|	МобильноеПриложение.Наименование = &ПредлагаемоеНаименование
		|
		|УПОРЯДОЧИТЬ ПО
		|	Наименование УБЫВ";
		Запрос.УстановитьПараметр("ПредлагаемоеНаименование", ПредлагаемоеНаименование);
		РезультатЗапроса = Запрос.Выполнить();
	КонецЕсли;
	
	ВыборкаРезультата = РезультатЗапроса.Выбрать();
	
	Если ВыборкаРезультата.Следующий() Тогда
		НаименованиеУзла = СтрЗаменить(НРег(ВыборкаРезультата.Наименование), НРег(ПредлагаемоеНаименование), "");
		Номер = СтрЗаменить(НаименованиеУзла, " #", "");
		Если ПустаяСтрока(Номер) Тогда
			СледующийНомер = 1;
		Иначе
			Попытка
				СледующийНомер = Число(СокрЛП(Номер)) + 1;
			Исключение
				СледующийНомер = 1;
			КонецПопытки;
		КонецЕсли;
		Возврат ПредлагаемоеНаименование + " #" + Строка(СледующийНомер); 
	Иначе	
		Возврат ПредлагаемоеНаименование; 
	КонецЕсли;
	
КонецФункции

Процедура ОбновитьАдресЭлектроннойПочты(Знач ПользовательОбъект, Знач Адрес, Знач СтруктураАдресаЭП)
	
	ВидКИ = Справочники.ВидыКонтактнойИнформации.EmailПользователя;
	
	СтрокаТабличнойЧасти = ПользовательОбъект.КонтактнаяИнформация.Найти(ВидКИ, "Вид");
	Если СтруктураАдресаЭП = Неопределено Тогда
		Если СтрокаТабличнойЧасти <> Неопределено Тогда
			ПользовательОбъект.КонтактнаяИнформация.Удалить(СтрокаТабличнойЧасти);
		КонецЕсли;
	Иначе
		Если СтрокаТабличнойЧасти = Неопределено Тогда
			СтрокаТабличнойЧасти = ПользовательОбъект.КонтактнаяИнформация.Добавить();
			СтрокаТабличнойЧасти.Вид = ВидКИ;
		КонецЕсли;
		СтрокаТабличнойЧасти.Тип = Перечисления.ТипыКонтактнойИнформации.АдресЭлектроннойПочты;
		СтрокаТабличнойЧасти.Представление = Адрес;
		
		Если СтруктураАдресаЭП.Количество() > 0 Тогда
			СтрокаТабличнойЧасти.АдресЭП = СтруктураАдресаЭП[0].Адрес;
			
			Поз = СтрНайти(СтрокаТабличнойЧасти.АдресЭП, "@");
			Если Поз <> 0 Тогда
				СтрокаТабличнойЧасти.ДоменноеИмяСервера = Сред(СтрокаТабличнойЧасти.АдресЭП, Поз + 1);
			КонецЕсли;
		КонецЕсли;
	КонецЕсли;
	
КонецПроцедуры

Функция ПолучитьСтруктуруАдресаЭлектроннойПочты(Знач АдресЭлектроннойПочты)
	
	Если ЗначениеЗаполнено(АдресЭлектроннойПочты) Тогда
		
		Попытка
			СтруктураАдресаЭП = ОбщегоНазначенияКлиентСервер.РазобратьСтрокуСПочтовымиАдресами(АдресЭлектроннойПочты);
		Исключение
			ШаблонСообщения = НСтр("ru = 'Указан некорректный адрес электронной почты: %1
				|Ошибка: %2'");
			ТекстСообщения = СтроковыеФункцииКлиентСервер.ПодставитьПараметрыВСтроку(ШаблонСообщения, АдресЭлектроннойПочты, ИнформацияОбОшибке().Описание);
			ВызватьИсключение(ТекстСообщения);
		КонецПопытки;
		
		Возврат СтруктураАдресаЭП;
	Иначе
		Возврат Неопределено;
	КонецЕсли;
	
КонецФункции

Процедура ПроверитьВозможностьДобавленияновогоУзла()
	
	МобильноеПриложениеВызовСервера.ПередНачаломРаботыКлиента();
	Если МобильноеПриложениеВызовСервера.НужноОграничитьФункциональность() Тогда
		ВыборкаПлановОбмена = ПланыОбмена.МобильноеПриложение.Выбрать();
		Сч = 0;
		Пока ВыборкаПлановОбмена.Следующий() Цикл
			Сч = Сч + 1;
		КонецЦикла;
		Если Сч >= 4 Тогда
			ВызватьИсключение(НСтр("ru='Ваш тарифный план не позволяет подключать больше 3-х мобильных приложений.'"));
		КонецЕсли;
	КонецЕсли;
	
КонецПроцедуры

Функция СоздатьКассуККМ(НаименованиеМобильногоКомпьютера)
	
	СправочникКассаККМ = Справочники.КассыККМ.СоздатьЭлемент();
	СправочникКассаККМ.Наименование = НСтр("ru='Касса ККМ'") + " (" + НаименованиеМобильногоКомпьютера + ")";
	СправочникКассаККМ.ИспользоватьБезПодключенияОборудования = Истина;
	СправочникКассаККМ.ТипКассы = Перечисления.ТипыКассККМ.ФискальныйРегистратор;
	СправочникКассаККМ.Подразделение = Справочники.СтруктурныеЕдиницы.ОсновноеПодразделение;
	СправочникКассаККМ.СтруктурнаяЕдиница = Справочники.СтруктурныеЕдиницы.ОсновнойСклад;
	СправочникКассаККМ.ВалютаДенежныхСредств = Константы.НациональнаяВалюта.Получить();
	СправочникКассаККМ.СчетУчета = ПланыСчетов.Управленческий.Касса;
	ЗначениеНастройки = УправлениеНебольшойФирмойПовтИсп.ПолучитьЗначениеПоУмолчаниюПользователя(Пользователи.ТекущийПользователь(), "ОсновнаяОрганизация");
	Если ЗначениеЗаполнено(ЗначениеНастройки) Тогда
		СправочникКассаККМ.Владелец = ЗначениеНастройки;
	Иначе
		СправочникКассаККМ.Владелец = Справочники.Организации.ОрганизацияПоУмолчанию();
	КонецЕсли;
	СправочникКассаККМ.Записать();
	Возврат СправочникКассаККМ.Ссылка;
	
КонецФункции

#КонецОбласти

#Область ФункцииДляПоддержкиСовместимости

Функция НачатьОбмен(КодМобильногоКомпьютера, НаименованиеМобильногоКомпьютера, НомерОтправленного, НомерПринятого, ПериодВыгрузки)
	
	Пользователь = Пользователи.АвторизованныйПользователь();
	
	ПроверитьПраваПользователя(Пользователь);
	ПроверитьДоступУстройства(КодМобильногоКомпьютера);
	
	УстановитьПривилегированныйРежим(Истина);
	
	ПериодВыгрузкиВМобильноеПриложениеУстановленный = УправлениеНебольшойФирмойПовтИсп.ПолучитьЗначениеПоУмолчаниюПользователя(
		Пользователь,
		"ПериодВыгрузкиВМобильноеПриложение"
	);

	Если ПериодВыгрузки = "За последний квартал" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнийКвартал;
	ИначеЕсли ПериодВыгрузки = "За последний месяц" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнийМесяц;
	ИначеЕсли ПериодВыгрузки = "За последнюю неделю" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнююНеделю;
	ИначеЕсли ПериодВыгрузки = "За последний день" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнийДень;
	Иначе
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаВсеВремя;
	КонецЕсли;
	
	Если ПериодВыгрузкиВМобильноеПриложениеУстановленный <> ПериодВыгрузкиВМобильноеПриложение Тогда
		УправлениеНебольшойФирмойСервер.УстановитьНастройкуПользователя(ПериодВыгрузкиВМобильноеПриложение, "ПериодВыгрузкиВМобильноеПриложение")
	КонецЕсли;
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.ЭтотУзел().ПолучитьОбъект();
	Если НЕ ЗначениеЗаполнено(УзелОбмена.Код) Тогда
		
		УзелОбмена.ОбменДанными.Загрузка = Истина;
		УзелОбмена.Код = "001";
		УзелОбмена.Наименование = "Центральный";
		УзелОбмена.Записать();
		
	КонецЕсли;
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.НайтиПоКоду(КодМобильногоКомпьютера); 
	Если УзелОбмена.Пустая() Тогда
		
		ПроверитьВозможностьДобавленияновогоУзла();
		
		НовыйУзел = ПланыОбмена.МобильноеПриложение.СоздатьУзел();
		НовыйУзел.Код = КодМобильногоКомпьютера;
		НовыйУзел.Наименование = НаименованиеМобильногоКомпьютера;
		НовыйУзел.НомерОтправленного = НомерОтправленного;
		НовыйУзел.НомерПринятого = НомерПринятого;
		НовыйУзел.КассаККМ = СоздатьКассуККМ(НовыйУзел.Наименование);
		НовыйУзел.Записать();
		ОбменМобильноеПриложениеОбщее.ЗарегистрироватьИзмененияДанных(НовыйУзел.Ссылка);
		УзелОбмена = НовыйУзел.Ссылка;
		
	Иначе
		
		Если УзелОбмена.ПометкаУдаления ИЛИ
			УзелОбмена.Наименование <> НаименованиеМобильногоКомпьютера Тогда
			
			Узел = УзелОбмена.ПолучитьОбъект();
			Узел.ПометкаУдаления = Ложь;
			Узел.Наименование = НаименованиеМобильногоКомпьютера;
			Узел.Записать();
			
		КонецЕсли;
		
		Если НЕ ЗначениеЗаполнено(Узел.КассаККМ) Тогда
			Узел.КассаККМ = СоздатьКассуККМ(Узел.Наименование);
		КонецЕсли;
		
		Если УзелОбмена.НомерОтправленного <> НомерОтправленного ИЛИ
			 УзелОбмена.НомерПринятого <> НомерПринятого Тогда
			
			Узел = УзелОбмена.ПолучитьОбъект();
			Узел.НомерОтправленного = НомерОтправленного;
			Узел.НомерПринятого = НомерПринятого;
			Узел.Записать();
			
			ПланыОбмена.УдалитьРегистрациюИзменений(УзелОбмена);
			ОбменМобильноеПриложениеОбщее.ЗарегистрироватьИзмененияДанных(УзелОбмена);
			
		КонецЕсли;
		
	КонецЕсли;
	
КонецФункции

Функция ПринятьПакетОбмена(ДанныеМобильногоПриложения, КодМобильногоКомпьютера, НаименованиеМобильногоКомпьютера, НомерОтправленного, НомерПринятого, ПериодВыгрузки)
	
	СтруктураОтвета = Новый Структура("ИдентификаторЗадания, НовыйОбмен", Неопределено, Ложь);
	
	Пользователь = Пользователи.АвторизованныйПользователь();
	
	ПроверитьПраваПользователя(Пользователь);
	ПроверитьДоступУстройства(КодМобильногоКомпьютера);
	
	УстановитьПривилегированныйРежим(Истина);
	
	ПериодВыгрузкиВМобильноеПриложениеУстановленный = УправлениеНебольшойФирмойПовтИсп.ПолучитьЗначениеПоУмолчаниюПользователя(
		Пользователь,
		"ПериодВыгрузкиВМобильноеПриложение"
	);

	Если ПериодВыгрузки = "За последний квартал" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнийКвартал;
	ИначеЕсли ПериодВыгрузки = "За последний месяц" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнийМесяц;
	ИначеЕсли ПериодВыгрузки = "За последнюю неделю" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнююНеделю;
	ИначеЕсли ПериодВыгрузки = "За последний день" Тогда
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаПоследнийДень;
	Иначе
		ПериодВыгрузкиВМобильноеПриложение = Перечисления.ПериодыВыгрузкиВМобильноеПриложение.ЗаВсеВремя;
	КонецЕсли;
	
	Если ПериодВыгрузкиВМобильноеПриложениеУстановленный <> ПериодВыгрузкиВМобильноеПриложение Тогда
		УправлениеНебольшойФирмойСервер.УстановитьНастройкуПользователя(ПериодВыгрузкиВМобильноеПриложение, "ПериодВыгрузкиВМобильноеПриложение")
	КонецЕсли;
	
	СтруктураОтбора = Новый Структура("Наименование", КодМобильногоКомпьютера);
	МассивЗаданий = ФоновыеЗадания.ПолучитьФоновыеЗадания(СтруктураОтбора);
	ЕстьАктивноеЗадание = Ложь;
	Для Каждого ФоновоеЗадание Из МассивЗаданий Цикл
		Если ФоновоеЗадание.Состояние = СостояниеФоновогоЗадания.Активно Тогда
			ФоновоеЗадание.Отменить();
		КонецЕсли;
	КонецЦикла;
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.ЭтотУзел().ПолучитьОбъект();
	Если НЕ ЗначениеЗаполнено(УзелОбмена.Код) Тогда
		
		УзелОбмена.ОбменДанными.Загрузка = Истина;
		УзелОбмена.Код = "001";
		УзелОбмена.Наименование = "Центральный";
		УзелОбмена.Записать();
		
	КонецЕсли;
	
	НужнаИнициализацияУзла = Ложь;
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.НайтиПоКоду(КодМобильногоКомпьютера); 
	Если УзелОбмена.Пустая() Тогда
		
		ПроверитьВозможностьДобавленияновогоУзла();
		
		НовыйУзел = ПланыОбмена.МобильноеПриложение.СоздатьУзел();
		НовыйУзел.Код = КодМобильногоКомпьютера;
		НовыйУзел.Наименование = НаименованиеМобильногоКомпьютера;
		НовыйУзел.НомерОтправленного = НомерОтправленного;
		НовыйУзел.НомерПринятого = НомерПринятого;
		НовыйУзел.КассаККМ = СоздатьКассуККМ(НовыйУзел.Наименование);
		НовыйУзел.Записать();
		УзелОбмена = НовыйУзел.Ссылка;
		НужнаИнициализацияУзла = Истина;
		
	Иначе
		
		Если УзелОбмена.ПометкаУдаления ИЛИ
			УзелОбмена.Наименование <> НаименованиеМобильногоКомпьютера Тогда
			
			Узел = УзелОбмена.ПолучитьОбъект();
			Узел.ПометкаУдаления = Ложь;
			Узел.Наименование = НаименованиеМобильногоКомпьютера;
			Узел.Записать();
			
		КонецЕсли;
		
		Если НЕ ЗначениеЗаполнено(Узел.КассаККМ) Тогда
			Узел.КассаККМ = СоздатьКассуККМ(Узел.Наименование);
		КонецЕсли;
		
		Если УзелОбмена.НомерОтправленного = 0
			ИЛИ УзелОбмена.НомерПринятого = 0
			ИЛИ УзелОбмена.НомерОтправленного < НомерПринятого
			ИЛИ УзелОбмена.НомерПринятого <> НомерОтправленного Тогда
			
			Узел = УзелОбмена.ПолучитьОбъект();
			Узел.НомерОтправленного = НомерПринятого;
			Узел.НомерПринятого = НомерОтправленного;
			Узел.Записать();
			
			НужнаИнициализацияУзла = Истина;
			
		КонецЕсли;
		
	КонецЕсли;
	
	ОбменМобильноеПриложениеОбщее.ОбработатьПринятыйПакетЗагрузки(УзелОбмена, ДанныеМобильногоПриложения);
	
	ОбменМобильноеПриложениеОбщее.ЗапуститьФормированиеОчередиСообщенийОбмена(УзелОбмена, КодМобильногоКомпьютера, НомерПринятого, НужнаИнициализацияУзла, СтруктураОтвета.ИдентификаторЗадания);
	СтруктураОтвета.НовыйОбмен = НужнаИнициализацияУзла;
	
	Возврат Новый ХранилищеЗначения(СтруктураОтвета, Новый СжатиеДанных(9));
	
КонецФункции

Функция ОтправитьПакетОбменаВСервисТолькоМобильнаяТелефония(ДанныеМобильногоПриложения, КодМобильногоКомпьютера, НаименованиеМобильногоКомпьютера, НомерОтправленного, НомерПринятого, ПериодВыгрузки, ВерсияМобильногоПриложения, ИДПодписчика)
	
	СтруктураОтвета = Новый Структура("ИдентификаторЗадания, НовыйОбмен", Неопределено, Ложь);
	
	Пользователь = Пользователи.АвторизованныйПользователь();
	ПроверитьДоступУстройства(КодМобильногоКомпьютера);

	УстановитьПривилегированныйРежим(Истина);
	
	СтруктураОтбора = Новый Структура("Наименование", КодМобильногоКомпьютера);
	МассивЗаданий = ФоновыеЗадания.ПолучитьФоновыеЗадания(СтруктураОтбора);
	ЕстьАктивноеЗадание = Ложь;
	Для каждого ФоновоеЗадание Из МассивЗаданий Цикл
		Если ФоновоеЗадание.Состояние = СостояниеФоновогоЗадания.Активно Тогда
			ФоновоеЗадание.Отменить();
		КонецЕсли;
	КонецЦикла;
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.ЭтотУзел().ПолучитьОбъект();
	Если НЕ ЗначениеЗаполнено(УзелОбмена.Код) Тогда
		УзелОбмена.ОбменДанными.Загрузка = Истина;
		УзелОбмена.Код = "001";
		УзелОбмена.Наименование = "Центральный";
		УзелОбмена.Записать();
	КонецЕсли;
	
	НужнаИнициализацияУзла = Ложь;
	
	УзелОбмена = ПланыОбмена.МобильноеПриложение.НайтиПоКоду(КодМобильногоКомпьютера); 
	Если УзелОбмена.Пустая() Тогда
		
		ПроверитьВозможностьДобавленияновогоУзла();
		
		НовыйУзел = ПланыОбмена.МобильноеПриложение.СоздатьУзел();
		НовыйУзел.Код = КодМобильногоКомпьютера;

		НовыйУзел.Наименование = ПолучитьНаименованиеНовогоУзла(НаименованиеМобильногоКомпьютера);
		НовыйУзел.ВерсияМобильногоПриложения = ВерсияМобильногоПриложения;
		НовыйУзел.НомерОтправленного = НомерОтправленного;
		НовыйУзел.НомерПринятого = НомерПринятого;
		НовыйУзел.ДатаПоследнейСинхронизации = ТекущаяДатаСеанса();
		НовыйУзел.КассаККМ = СоздатьКассуККМ(НовыйУзел.Наименование);
		
		ПрофильПользователя = Перечисления.ПрофилиМобильногоПриложения.МобильнаяТелефония;
		НовыйУзел.УстановитьРолиПоПрофилю(ПрофильПользователя);
		
		//ПрофильПользователя = РегистрыСведений.ПрофилиМобильныхПользователей.ПолучитьПрофильПользователя(Пользователь);
		//Если ЗначениеЗаполнено(ПрофильПользователя) Тогда
		//	НовыйУзел.УстановитьРолиПоПрофилю(ПрофильПользователя);
		//	Если ПрофильПользователя = Перечисления.ПрофилиМобильногоПриложения.Собственник Тогда
		//		НовыйУзел.ПоВсемКассамККМ = Истина;
		//	КонецЕсли;
		//Иначе
		//	Если РольДоступна(Метаданные.Роли.ПолныеПрава) Тогда
		//		НовыйУзел.УстановитьРолиПоПрофилю(Перечисления.ПрофилиМобильногоПриложения.Собственник);
		//		НовыйУзел.ПоВсемКассамККМ = Истина;
		//	Иначе
		//		НовыйУзел.УстановитьРолиПоПрофилю(Перечисления.ПрофилиМобильногоПриложения.ДетальнаяНастройка);
		//		Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеКонтрагентов) Тогда
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.КонтрагентыПросмотрИРедактирование);
		//		Конецесли;
		//		Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеНоменклатуры) Тогда
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.НоменклатураПросмотрИРедактирование);
		//		Конецесли;
		//		Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыПродажи) Тогда
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ЗаказыПросмотрИРедактирование);
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ДвиженияТоваровПросмотрИРедактирование);
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетОстаткиТоваровНаСкладахПросмотр);
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетПродажиПросмотр);
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетДолгиПросмотр);
		//			Если НЕ РольДоступна(Метаданные.Роли.ДобавлениеИзменениеНоменклатуры) Тогда
		//				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.НоменклатураТолькоПросмотр);
		//			КонецЕсли;
		//		Конецесли;
		//		Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыЗакупки) Тогда
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ДвиженияТоваровПросмотрИРедактирование);
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетОстаткиТоваровНаСкладахПросмотр);
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетДолгиПросмотр);
		//			Если НЕ РольДоступна(Метаданные.Роли.ДобавлениеИзменениеНоменклатуры) Тогда
		//				НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.НоменклатураТолькоПросмотр);
		//			КонецЕсли;
		//		Конецесли;
		//		Если РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыКасса)
		//			ИЛИ РольДоступна(Метаданные.Роли.ДобавлениеИзменениеПодсистемыБанк) Тогда
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ДвиженияДенегПросмотрИРедактирование);
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетДвиженияДенегПросмотр);
		//			НовыйУзел.ДобавитьРольВТаблицу(Перечисления.РолиМобильногоПриложения.ОтчетДолгиПросмотр);
		//		Конецесли;
		//	КонецЕсли;
		//КонецЕсли;
		
		Если ИДПодписчика <> Неопределено Тогда
			НовыйУзел.ИДПодписчика = Новый ХранилищеЗначения(ИДПодписчика);
		КонецЕсли;
		
		НовыйУзел.Записать();
		УзелОбмена = НовыйУзел.Ссылка;
		НужнаИнициализацияУзла = Истина;
		
	Иначе
		
		Узел = УзелОбмена.ПолучитьОбъект();
		
		Если УзелОбмена.ПометкаУдаления ИЛИ
			УзелОбмена.Наименование <> НаименованиеМобильногоКомпьютера ИЛИ
			УзелОбмена.ВерсияМобильногоПриложения <> ВерсияМобильногоПриложения ИЛИ
			(ИДПодписчика <> Неопределено И УзелОбмена.ИДПодписчика.Получить() = Неопределено) Тогда
			Узел.ПометкаУдаления = Ложь;
			Узел.ВерсияМобильногоПриложения = ВерсияМобильногоПриложения;
			Если ИДПодписчика <> Неопределено Тогда
				Узел.ИДПодписчика = Новый ХранилищеЗначения(ИДПодписчика);
			КонецЕсли;
		КонецЕсли;
		
		Если УзелОбмена.НомерОтправленного = 0
			ИЛИ УзелОбмена.НомерПринятого = 0
			ИЛИ УзелОбмена.НомерОтправленного < НомерПринятого
			ИЛИ УзелОбмена.НомерПринятого <> НомерОтправленного Тогда
			Узел.НомерОтправленного = НомерПринятого;
			Узел.НомерПринятого = НомерОтправленного;
			НужнаИнициализацияУзла = Истина;
		КонецЕсли;
		
		ПрофильПользователя = Перечисления.ПрофилиМобильногоПриложения.МобильнаяТелефония;
		Если Узел.Профиль <> ПрофильПользователя Тогда
			НовыйУзел.УстановитьРолиПоПрофилю(ПрофильПользователя);
			НужнаИнициализацияУзла = Истина;
		КонецЕсли;
		
		Узел.ДатаПоследнейСинхронизации = ТекущаяДатаСеанса();
		Узел.Записать();
		
	КонецЕсли;
	
	ОбменМобильноеПриложениеОбщее.ОбработатьПринятыйПакетЗагрузки(УзелОбмена, ДанныеМобильногоПриложения, Ложь, Истина);
	ОбменМобильноеПриложениеОбщее.ЗапуститьФормированиеОчередиСообщенийОбмена(УзелОбмена, КодМобильногоКомпьютера, НомерПринятого, НужнаИнициализацияУзла, СтруктураОтвета.ИдентификаторЗадания, Истина);
	СтруктураОтвета.НовыйОбмен = НужнаИнициализацияУзла;
	
	Возврат Новый ХранилищеЗначения(СтруктураОтвета, Новый СжатиеДанных(9));

КонецФункции


#КонецОбласти
